function [last_episodes]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K)

%This function returns:

%last_episodes: A Kx(2*N+3) matrix containing for each experiment k, the
%values in the last episode T of A_N (quoted price of AMM N) and opt_N (greedy price of AMM N) for each AMM, 
%as well as v_tilde (asset's fundamental value), vc (client's total valuation for the asset), 
%C_T (number of consecutive episodes before T in which all AMMs play the same price as in T).

%In the case N=2 for instance the columns of last_episodes are ordered as follows:
%1: A_1
%2: A_2
%3: opt_1
%4: opt_2
%5: v_tilde
%6: vc
%7: C_T

%Initialize
last_episodes = zeros(K,2*N+3);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.

parfor k=1:K
    %Calls the function simulation_exp
    [last_episode] = simulation_exp(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N);
    %Records the last episode
    last_episodes(k,:) = last_episode;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end
